package com.ym.im.entity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author JJww
 */

@Getter
@AllArgsConstructor
public enum RoleEnum {

    APP("app", 0),
    merchant("mer", 1),
    system("sys", 2);

    private final String type;

    private final Integer key;

    public static RoleEnum get(String type) {
        for (RoleEnum roleEnum : values()) {
            if (roleEnum.getType().equals(type)) {
                //获取指定的枚举
                return roleEnum;
            }
        }
        return null;
    }

    public static RoleEnum get(Integer key) {
        for (RoleEnum roleEnum : values()) {
            if (roleEnum.getKey().equals(key)) {
                //获取指定的枚举
                return roleEnum;
            }
        }
        return null;
    }


}
