package com.jumeirah.common.service;

import com.jumeirah.common.entity.MerchantUserPermission;
import com.jumeirah.common.param.MerchantUserPermissionDetailVo;
import com.jumeirah.common.param.MerchantUserPermissionPageParam;
import com.jumeirah.common.param.MerchantUserPermissionQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

import java.util.List;
import java.util.Set;

/**
 * 商家用户权限关系 服务类
 *
 * @author giao
 * @since 2020-10-19
 */
public interface MerchantUserPermissionService extends BaseService<MerchantUserPermission> {

        /**
         * 根据角色id获取可用的权限编码
         *
         * @param userId
         * @return
         * @throws Exception
         */
        Set<String> getPermissionCodesByUserId(Long userId) throws Exception;

        /**
         * 保存
         *
         * @param merchantUserPermission
         * @return
         * @throws Exception
         */
        boolean saveMerchantUserPermission(MerchantUserPermission merchantUserPermission) throws Exception;

        /**
         * 修改
         *
         * @param merchantUserPermission
         * @return
         * @throws Exception
         */
        boolean updateMerchantUserPermission(MerchantUserPermission merchantUserPermission) throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteMerchantUserPermission(Long id) throws Exception;

        /**
         * 根据ID获取查询对象
         *
         * @param id
         * @return
         * @throws Exception
         */
        MerchantUserPermissionQueryVo getMerchantUserPermissionById(Long id) throws Exception;

        /**
         * 根据user获取查询对象
         *
         * @param userId
         * @return
         * @throws Exception
         */
        List<MerchantUserPermissionDetailVo> getMerchantUserPermissionByUserId(Long userId) throws Exception;


        /**
         * 获取分页对象
         *
         * @param merchantUserPermissionPageParam
         * @return
         * @throws Exception
         */
        Paging<MerchantUserPermissionQueryVo> getMerchantUserPermissionPageList(MerchantUserPermissionPageParam merchantUserPermissionPageParam) throws Exception;

}
