package com.jumeirah.api.app.entity.bo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.jumeirah.common.entity.PlainType;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 飞机型号表
 *
 * @author wei
 * @since 2020-10-09
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "分组获取飞机类型对象")
public class PlainTypeBo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系列名称")
    private String title;

    @ApiModelProperty("系列名称")
    private List<PlainType> plainTypeList;

}
