package com.jumeirah.api.merchant.entity.param;

import com.jumeirah.common.entity.base.ImgJson;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 公务机出售/托管表
 *
 * @author giao
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "BusinessPlain对象")
public class McBusinessPlainAddParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键ID")
    private Long id;

    @NotNull(message = "业务类型，0-出售，1-托管不能为空")
    @ApiModelProperty("业务类型，0-出售，1-托管")
    private Integer businessType;

    @ApiModelProperty("机型介绍")
    private String introduction;

    @ApiModelProperty("销售员姓名")
    private String name;

    @ApiModelProperty("销售联系电话")
    private String phone;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("图片相关数据json")
    private List<ImgJson> imgUrl;
}
