package com.jumeirah.api.merchant.controller.plain;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jumeirah.api.merchant.entity.param.McPlainAddParam;
import com.jumeirah.common.entity.McPlain;
import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.enums.PlainTypeStatusEnum;
import com.jumeirah.common.param.McPlainPageParam;
import com.jumeirah.common.service.McPlainService;
import com.jumeirah.common.service.PlainTypeService;
import com.jumeirah.common.vo.McPlainQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiCode;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商家飞机表 控制器
 *
 * @author xxx
 * @since 2020-10-19
 */
@Slf4j
@RestController
@RequestMapping("/merchant/mcPlain")
@Api(value = "商家飞机表API", tags = {"商家飞机表"})
public class McPlainController extends BaseController {

    @Autowired
    private McPlainService mcPlainService;

    @Autowired
    private PlainTypeService plainTypeService;

    /**
     * 添加商家飞机表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加商家飞机表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加商家飞机表")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> addMcPlain(@Validated(Add.class) @RequestBody McPlainAddParam mcPlainAddParam) throws Exception {
        if (checkPtId(mcPlainAddParam)) {
            return ApiResult.result(ApiCode.PLAIN_TYPE_NOT_FOUND, null);
        }
        //先判断商家此机型是否已经添加过
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        if (checkMcPlain(mcPlainAddParam.getPtId(), jwtToken.getMcId())) {
            return ApiResult.result(ApiCode.MC_PLANE_EXISTED, false);
        }
        McPlain mcPlain = new McPlain();
        BeanUtils.copyProperties(mcPlainAddParam, mcPlain);
        mcPlain.setMcId(jwtToken.getMcId())
                .setIdleNum(mcPlainAddParam.getAmount());
        boolean flag = mcPlainService.saveMcPlain(mcPlain);
        return ApiResult.result(flag);
    }

    private boolean checkPtId(@RequestBody @Validated(Add.class) McPlainAddParam mcPlainAddParam) {
        PlainType plainType = plainTypeService.getById(mcPlainAddParam.getPtId());
        if (plainType == null || plainType.getStatus().intValue() == PlainTypeStatusEnum.CANCEL.getCode()) {
            return true;
        }
        return false;
    }

    /**
     * 修改商家飞机表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改商家飞机表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改商家飞机表")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> updateMcPlain(@Validated(Update.class) @RequestBody McPlainAddParam mcPlainAddParam) throws Exception {
        if (checkPtId(mcPlainAddParam)) {
            return ApiResult.result(ApiCode.PLAIN_TYPE_NOT_FOUND, null);
        }
        //先判断商家此机型是否已经添加过
        McPlain oldMcPlain = mcPlainService.getById(mcPlainAddParam.getId());
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        if (oldMcPlain.getPtId().longValue() != mcPlainAddParam.getPtId().longValue()) {
            if (checkMcPlain(mcPlainAddParam.getPtId(), jwtToken.getMcId())) {
                return ApiResult.result(ApiCode.MC_PLANE_EXISTED, false);
            }
        }
        int idleNum = oldMcPlain.getIdleNum();
        if (mcPlainAddParam.getAmount() < oldMcPlain.getAmount()) {
            //减少数量
            idleNum = oldMcPlain.getIdleNum() - (oldMcPlain.getAmount() - mcPlainAddParam.getAmount());
            idleNum = idleNum >= 0 ? idleNum : 0;
        } else if (oldMcPlain.getAmount() < mcPlainAddParam.getAmount()) {
            //增加数量
            idleNum = oldMcPlain.getIdleNum() + (mcPlainAddParam.getAmount() - oldMcPlain.getAmount());
            idleNum = idleNum >= mcPlainAddParam.getAmount() ? mcPlainAddParam.getAmount() : idleNum;
        }
        McPlain mcPlain = new McPlain();
        BeanUtils.copyProperties(mcPlainAddParam, mcPlain);
        mcPlain.setIdleNum(idleNum);
        boolean flag = mcPlainService.updateMcPlain(mcPlain);
        return ApiResult.result(flag);
    }

    private boolean checkMcPlain(Long ptId, Long mcId) {
        McPlain oldMcPlain = mcPlainService.getOne(new QueryWrapper<McPlain>().lambda()
                .eq(McPlain::getPtId, ptId)
                .eq(McPlain::getMcId, mcId));
        if (oldMcPlain != null) {
            return true;
        }
        return false;
    }

    /**
     * 删除商家飞机表
     */
    @PostMapping("/delete/{id}")
    @RequiresPermissions("merchant:aircraft:management:edit")
    @OperationLog(name = "删除商家飞机表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除商家飞机表")
    public ApiResult<Boolean> deleteMcPlain(@PathVariable("id") Long id) throws Exception {
        boolean flag = mcPlainService.deleteMcPlain(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取商家飞机表详情
     */
  /*  @GetMapping("/info/{id}")
    @OperationLog(name = "商家飞机表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "商家飞机表详情")
    public ApiResult<McPlainQueryVo> getMcPlain(@PathVariable("id") Long id) throws Exception {
        McPlainQueryVo mcPlainQueryVo = mcPlainService.getMcPlainById(id);
        return ApiResult.ok(mcPlainQueryVo);
    }*/

    /**
     * 商家飞机表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "商家飞机表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "商家飞机表分页列表")
    @RequiresPermissions("merchant:aircraft:management:view")
    public ApiResult<Paging<McPlainQueryVo>> getMcPlainPageList(@Validated @RequestBody McPlainPageParam mcPlainPageParam) throws Exception {
        Paging<McPlainQueryVo> paging = mcPlainService.getMcPlainPageList(mcPlainPageParam);
        return ApiResult.ok(paging);
    }

}

