package com.ym.im.controller;

import com.ym.im.entity.IdModel;
import com.ym.im.entity.MsgBody;
import com.ym.im.service.UserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author: JJww
 * @Date:2019-07-24
 */
@RestController
@RequestMapping("/user")
@Api(description = "用户相关")
public class UserController {

    @Autowired
    private UserService userService;

    @GetMapping("/list")
    @ApiOperation(value = "获取当前用户列表(ID)")
    @ApiImplicitParams({@ApiImplicitParam(name = "staffId", value = "客服ID", required = true, dataType = "Long", paramType = "query")})
    public MsgBody getUserId(Long staffId) {
        return userService.getUserList(staffId);
    }

    @DeleteMapping("/list")
    @ApiOperation(value = "从列表中删除用户")
    public MsgBody deleteUserFromList(@Valid @RequestBody IdModel idModel) {
        return userService.deleteUserFromList(idModel);
    }

    @GetMapping("/checkBinding")
    @ApiOperation(value = "查询用户绑定情况")
    public MsgBody checkBinding(@Valid @ModelAttribute IdModel idModel) {
        return userService.checkBinding(idModel);
    }

}
