package com.jumeirah.api.merchant.entity.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 优惠行程表
 *
 * @author xxx
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "StrokeDiscount对象")
public class McStrokeDiscountAddParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键ID")
    private Long id;

    @NotNull(message = "出发城市id不能为空")
    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @NotNull(message = "到达城市id不能为空")
    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @NotNull(message = "座位数不能为空")
    @ApiModelProperty("座位数")
    private Integer seatNum;

    @NotNull(message = "飞机型号ID不能为空")
    @ApiModelProperty("飞机型号ID")
    private Long plainTypeId;

    @ApiModelProperty("飞机型号名称")
    private String plainTypeName;

    @ApiModelProperty("价格")
    private BigDecimal money;

}
