package com.jumeirah.common.controller;

import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.service.StrokeService;
import lombok.extern.slf4j.Slf4j;
        import com.jumeirah.common.param.StrokePageParam;
        import io.geekidea.springbootplus.framework.common.controller.BaseController;
        import com.jumeirah.common.vo.StrokeQueryVo;
    import io.geekidea.springbootplus.framework.common.api.ApiResult;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.common.param.IdParam;
        import io.geekidea.springbootplus.framework.log.annotation.Module;
        import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
        import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
        import io.geekidea.springbootplus.framework.core.validator.groups.Add;
        import io.geekidea.springbootplus.framework.core.validator.groups.Update;
        import org.springframework.validation.annotation.Validated;
    import io.swagger.annotations.Api;
    import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 行程表 控制器
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@RestController
@RequestMapping("/stroke")
@Module("${cfg.module}")
@Api(value = "行程表API", tags = {"行程表"})
    public class StrokeController extends BaseController {

@Autowired
private StrokeService strokeService;

    /**
     * 添加行程表
     */
    @PostMapping("/add")
        @OperationLog(name = "添加行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加行程表", response = ApiResult.class)
    public ApiResult<Boolean> addStroke(@Validated(Add.class) @RequestBody Stroke stroke)throws Exception{
            boolean flag= strokeService.saveStroke(stroke);
            return ApiResult.result(flag);
            }

    /**
     * 修改行程表
     */
    @PostMapping("/update")
        @OperationLog(name = "修改行程表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改行程表", response = ApiResult.class)
    public ApiResult<Boolean> updateStroke(@Validated(Update.class) @RequestBody Stroke stroke)throws Exception{
            boolean flag= strokeService.updateStroke(stroke);
            return ApiResult.result(flag);
            }

    /**
     * 删除行程表
     */
    @PostMapping("/delete/{id}")
        @OperationLog(name = "删除行程表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除行程表", response = ApiResult.class)
    public ApiResult<Boolean> deleteStroke(@PathVariable("id") Long id)throws Exception{
            boolean flag= strokeService.deleteStroke(id);
            return ApiResult.result(flag);
            }

    /**
     * 获取行程表详情
     */
    @GetMapping("/info/{id}")
        @OperationLog(name = "行程表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "行程表详情", response = StrokeQueryVo.class)
    public ApiResult<StrokeQueryVo> getStroke(@PathVariable("id") Long id)throws Exception{
            StrokeQueryVo strokeQueryVo = strokeService.getStrokeById(id);
            return ApiResult.ok(strokeQueryVo);
            }

    /**
     * 行程表分页列表
     */
    @PostMapping("/getPageList")
        @OperationLog(name = "行程表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "行程表分页列表", response = StrokeQueryVo.class)
    public ApiResult<Paging<StrokeQueryVo>>getStrokePageList(@Validated @RequestBody StrokePageParam strokePageParam)throws Exception{
            Paging<StrokeQueryVo> paging = strokeService.getStrokePageList(strokePageParam);
            return ApiResult.ok(paging);
            }

        }

