package com.jumeirah.api.app.entity.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

/**
 * 优惠行程表
 *
 * @author xxx
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "StrokeDiscount对象")
public class StrokeDiscountParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "优惠行程id不能为空")
    @ApiModelProperty("优惠行程ID")
    private Long sdId;

    @NotNull(message = "人数不能为空")
    @ApiModelProperty("人数")
    private Integer peopleNum;

    @NotNull(message = "出发时间不能为空")
    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

}
