package com.ym.im.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ym.im.validation.group.ChatRecordSaveGroup;
import com.ym.im.validation.group.StaffSendGroup;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.validation.groups.Default;
import java.io.Serializable;
import java.util.Date;

/**
 * @author: JJww
 * @Date:2020/10/21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("session_list")
public class Session implements Serializable {

    @NotNull(message = "{error.chat_id_empty}", groups = {Default.class, ChatRecordSaveGroup.class})
    @Positive(message = "{error.chat_id_greater_than_zero}", groups = {Default.class, ChatRecordSaveGroup.class})
    private Long id;

    @NotNull(message = "{error.user_id_empty}", groups = {Default.class, ChatRecordSaveGroup.class, StaffSendGroup.class})
    @Positive(message = "{error.user_id_greater_than_zero}", groups = {Default.class, ChatRecordSaveGroup.class, StaffSendGroup.class})
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    @NotNull(message = "{error.merchant_id_empty}", groups = {Default.class})
    @Positive(message = "{error.merchant_id_greater_than_zero}", groups = {Default.class})
    @ApiModelProperty(value = "商户ID")
    private Long merchantId;

    @NotNull(message = "{error.chat_create_time_empty}", groups = {Default.class, ChatRecordSaveGroup.class})
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @NotNull(message = "{error.chat_modify_time_empty}", groups = {Default.class})
    @ApiModelProperty(value = "修改时间）")
    private Date modifyTime;
}
