package com.jumeirah.common.service;

import com.jumeirah.common.entity.Feedback;
import com.jumeirah.common.param.FeedbackPageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.param.FeedbackQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 意见反馈 服务类
 *
 * @author giao
 * @since 2020-10-26
 */
public interface FeedbackService extends BaseService<Feedback> {

        /**
         * 保存
         *
         * @param feedback
         * @return
         * @throws Exception
         */
        boolean saveFeedback(Feedback feedback)throws Exception;

        /**
         * 修改
         *
         * @param feedback
         * @return
         * @throws Exception
         */
        boolean updateFeedback(Feedback feedback)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteFeedback(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        FeedbackQueryVo getFeedbackById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param feedbackPageParam
         * @return
         * @throws Exception
         */
        Paging<FeedbackQueryVo> getFeedbackPageList(FeedbackPageParam feedbackPageParam) throws Exception;

        }
