package com.jumeirah.api.merchant.controller.plain;

import com.jumeirah.api.merchant.entity.param.McStrokeDiscountAddParam;
import com.jumeirah.common.entity.StrokeDiscount;
import com.jumeirah.common.param.StrokeDiscountPageParam;
import com.jumeirah.common.service.StrokeDiscountService;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 优惠行程表 控制器
 *
 * @author xxx
 * @since 2020-10-14
 */
@Slf4j
@RestController
@RequestMapping("/merchant/strokeDiscount")
@Api(value = "优惠行程表API", tags = {"优惠行程表"})
public class McStrokeDiscountController extends BaseController {

    @Autowired
    private StrokeDiscountService strokeDiscountService;

    /**
     * 添加优惠行程表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加优惠行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加优惠行程表")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> addStrokeDiscount(@Validated(Add.class) @RequestBody McStrokeDiscountAddParam mcStrokeDiscountAddParam) throws Exception {
        StrokeDiscount strokeDiscount = new StrokeDiscount();
        BeanUtils.copyProperties(mcStrokeDiscountAddParam, strokeDiscount);
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        strokeDiscount.setMcId(jwtToken.getMcId());
        boolean flag = strokeDiscountService.saveStrokeDiscount(strokeDiscount);
        return ApiResult.result(flag);
    }

    /**
     * 修改优惠行程表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改优惠行程表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改优惠行程表")
    public ApiResult<Boolean> updateStrokeDiscount(@Validated(Update.class) @RequestBody McStrokeDiscountAddParam mcStrokeDiscountAddParam) throws Exception {
        StrokeDiscount strokeDiscount = new StrokeDiscount();
        BeanUtils.copyProperties(mcStrokeDiscountAddParam, strokeDiscount);
        boolean flag = strokeDiscountService.updateStrokeDiscount(strokeDiscount);
        return ApiResult.result(flag);
    }

    /**
     * 删除优惠行程表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除优惠行程表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除优惠行程表")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> deleteStrokeDiscount(@PathVariable("id") Long id) throws Exception {
        boolean flag = strokeDiscountService.deleteStrokeDiscount(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取优惠行程表详情
     */
    /*@GetMapping("/info/{id}")
    @OperationLog(name = "优惠行程表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "优惠行程表详情")
    public ApiResult<StrokeDiscountQueryVo> getStrokeDiscount(@PathVariable("id") Long id) throws Exception {
        StrokeDiscountQueryVo strokeDiscountQueryVo = strokeDiscountService.getStrokeDiscountById(id);
        return ApiResult.ok(strokeDiscountQueryVo);
    }*/

    /**
     * 优惠行程表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "优惠行程表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "优惠行程表分页列表")
    @RequiresPermissions("merchant:aircraft:management:view")
    public ApiResult<Paging<StrokeDiscountQueryVo>> getStrokeDiscountPageList(@Validated @RequestBody StrokeDiscountPageParam strokeDiscountPageParam) throws Exception {
        Paging<StrokeDiscountQueryVo> paging = strokeDiscountService.getStrokeDiscountPageList(strokeDiscountPageParam);
        return ApiResult.ok(paging);
    }

}

