package com.ym.im.config;


import lombok.Data;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: JJww
 * @Date:2019-05-30
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "spring.rabbitmq")
public class RabbitConfig {

    private String exchangeName;

    private String orderQueueName;

    private String staffOfflineQueueName;

    @Bean
    public Queue orderQueue() {
        return new Queue(orderQueueName);
    }

    @Bean
    public Queue staffOfflineQueue() {
        return new Queue(staffOfflineQueueName);
    }

    /**
     * 配置默认的交换机
     */
    @Bean
    CustomExchange customExchange() {
        Map<String, Object> args = new HashMap<>(1);
        args.put("x-delayed-type", "direct"); //参数二为类型：必须是x-delayed-message
        return new CustomExchange(exchangeName, "x-delayed-message", true, false, args);
    }

    /**
     * 绑定队列到交换器
     */
    @Bean
    Binding bindingStaffOfflineQueue(Queue staffOfflineQueue, CustomExchange customExchange) {
        return BindingBuilder.bind(staffOfflineQueue).to(customExchange).with(staffOfflineQueueName).noargs();
    }

}
