package com.jumeirah.common.service;

import com.jumeirah.common.entity.UserActiveRecord;
import com.jumeirah.common.param.UserActiveRecordPageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.param.UserActiveRecordQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * app用户活跃记录表 服务类
 *
 * @author giao
 * @since 2020-10-21
 */
public interface UserActiveRecordService extends BaseService<UserActiveRecord> {

        /**
         * 保存
         *
         * @param userActiveRecord
         * @return
         * @throws Exception
         */
        boolean saveUserActiveRecord(UserActiveRecord userActiveRecord)throws Exception;

        /**
         * 修改
         *
         * @param userActiveRecord
         * @return
         * @throws Exception
         */
        boolean updateUserActiveRecord(UserActiveRecord userActiveRecord)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteUserActiveRecord(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        UserActiveRecordQueryVo getUserActiveRecordById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param userActiveRecordPageParam
         * @return
         * @throws Exception
         */
        Paging<UserActiveRecordQueryVo> getUserActiveRecordPageList(UserActiveRecordPageParam userActiveRecordPageParam) throws Exception;

        }
