package com.jumeirah.common.service;

import com.jumeirah.common.entity.CharterIntroduction;
import com.jumeirah.common.param.CharterIntroductionPageParam;
import com.jumeirah.common.vo.CharterIntroductionQueryForAppVo;
import com.jumeirah.common.vo.CharterIntroductionQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 包机介绍 服务类
 *
 * @author giao
 * @since 2020-10-14
 */
public interface CharterIntroductionService extends BaseService<CharterIntroduction> {

    /**
     * 保存
     *
     * @param charterIntroduction
     * @return
     * @throws Exception
     */
    boolean saveCharterIntroduction(CharterIntroduction charterIntroduction) throws Exception;

    /**
     * 修改
     *
     * @param charterIntroduction
     * @return
     * @throws Exception
     */
    boolean updateCharterIntroduction(CharterIntroduction charterIntroduction) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteCharterIntroduction(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    CharterIntroductionQueryVo getCharterIntroductionById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param charterIntroductionPageParam
     * @return
     * @throws Exception
     */
    Paging<CharterIntroductionQueryVo> getCharterIntroductionPageList(CharterIntroductionPageParam charterIntroductionPageParam) throws Exception;

    Paging<CharterIntroductionQueryForAppVo> getCharterIntroductionForAppPageList(CharterIntroductionPageParam charterIntroductionPageParam) throws Exception;

}
