package com.jumeirah.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 包机介绍
 *
 * @author giao
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "CharterIntroduction对象")
public class CharterIntroduction extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键ID不能为空")
    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "商家ID不能为空")
    @ApiModelProperty("商家ID")
    private Long mcId;

    @ApiModelProperty("私人包机图片url")
    private String imgUrlPrivate;

    @ApiModelProperty("私人包机文字")
    private String textPrivate;

    @ApiModelProperty("团体包机图片url")
    private String imgUrlTeam;

    @ApiModelProperty("团体包机文字")
    private String textTeam;

    @ApiModelProperty("货运包机图片url")
    private String imgUrlGoods;

    @ApiModelProperty("货运包机文字")
    private String textGoods;

    @ApiModelProperty("医疗包机图片url")
    private String imgUrlMedical;

    @ApiModelProperty("医疗包机文字")
    private String textMedical;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("内容")
    private String contents;

    @NotNull(message = "状态，0-正常，1-取消，99-删除不能为空")
    @ApiModelProperty("状态，0-正常，1-取消，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

}
