package com.jumeirah.api.merchant.controller;

import com.jumeirah.common.entity.MerchantRole;
import com.jumeirah.common.param.MerchantRolePageParam;
import com.jumeirah.common.service.MerchantRoleService;
import com.jumeirah.common.vo.MerchantRoleQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 商家角色 控制器
 *
 * @author wei
 * @since 2020-09-27
 */
@Slf4j
@RestController
@RequestMapping("/merchant/role")
@Module("${cfg.module}")
@Api(value = "商家角色API", tags = {"商家角色"})
public class MerchantRoleController extends BaseController {

    @Autowired
    private MerchantRoleService merchantRoleService;

    /**
     * 添加商家角色
     */
    @PostMapping("/add")
    @OperationLog(name = "添加商家角色", type = OperationLogType.ADD)
    @ApiOperation(value = "添加商家角色", response = ApiResult.class)
    public ApiResult<Boolean> addMerchantRole(@Validated(Add.class) @RequestBody MerchantRole merchantRole) throws Exception {
        boolean flag = merchantRoleService.saveMerchantRole(merchantRole);
        return ApiResult.result(flag);
    }

    /**
     * 修改商家角色
     */
    @PostMapping("/update")
    @OperationLog(name = "修改商家角色", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改商家角色", response = ApiResult.class)
    public ApiResult<Boolean> updateMerchantRole(@Validated(Update.class) @RequestBody MerchantRole merchantRole) throws Exception {
        boolean flag = merchantRoleService.updateMerchantRole(merchantRole);
        return ApiResult.result(flag);
    }

    /**
     * 删除商家角色
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除商家角色", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除商家角色", response = ApiResult.class)
    public ApiResult<Boolean> deleteMerchantRole(@PathVariable("id") Long id) throws Exception {
        boolean flag = merchantRoleService.deleteMerchantRole(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取商家角色详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "商家角色详情", type = OperationLogType.INFO)
    @ApiOperation(value = "商家角色详情", response = MerchantRoleQueryVo.class)
    public ApiResult<MerchantRoleQueryVo> getMerchantRole(@PathVariable("id") Long id) throws Exception {
        MerchantRoleQueryVo merchantRoleQueryVo = merchantRoleService.getMerchantRoleById(id);
        return ApiResult.ok(merchantRoleQueryVo);
    }

    /**
     * 商家角色分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "商家角色分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "商家角色分页列表", response = MerchantRoleQueryVo.class)
    public ApiResult<Paging<MerchantRoleQueryVo>> getMerchantRolePageList(@Validated @RequestBody MerchantRolePageParam merchantRolePageParam) throws Exception {
        Paging<MerchantRoleQueryVo> paging = merchantRoleService.getMerchantRolePageList(merchantRolePageParam);
        return ApiResult.ok(paging);
    }

}

