package com.ym.im.entity;

import com.ym.im.validation.group.MsgBodyGroup;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author: JJww
 * @Date:2019-05-17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class MsgBody<T> implements Serializable {

    public static final int LOGOUT = -3;
    public static final int FORCEDOFFLINE = -2;
    public static final int ERROR = -1;
    public static final int SEND_MSG = 1;
    public static final int CHECK_MSG = 2;
    public static final int HAVE_READ = 3;
    public static final int USERS_ONLINE = 4;
    public static final int ORDER = 5;
    public static final int DISTRIBUTION_STAFF = 6;
    public static final int BINDINGFAILURE = 7;

    @NotNull(message = "{error.msg_body_status_empty}", groups = MsgBodyGroup.class)
    @ApiModelProperty(value = " * 操作类型说明\n" +
            "     * -3、登出\n" +
            "     * -2、被迫下线\n" +
            "     * -1、错误\n" +
            "     * 1、发送聊天消息\n" +
            "     * 2、确认接收聊天消息\n" +
            "     * 3、已读\n" +
            "     * 4、用户上线\n" +
            "     * 5、订单" +
            "     * 6、分配客服" +
            "     * 7、绑定失败"
    )
    private Integer code;

    @Valid
    @NotNull(message = "{error.msg_body_data_empty}", groups = MsgBodyGroup.class)
    @ApiModelProperty(value = "type值不同时data对应不同对象:1、发送聊天消息{@link ChatRecord} 2、确认接收聊天消息{@link ChatRecord}")
    private T data;

    @ApiModelProperty(value = "消息描述")
    private String message;

}