package com.jumeirah.common.service.impl;

import com.jumeirah.common.entity.UserActiveRecord;
import com.jumeirah.common.mapper.UserActiveRecordMapper;
import com.jumeirah.common.service.UserActiveRecordService;
    import com.jumeirah.common.param.UserActiveRecordPageParam;
    import com.jumeirah.common.param.UserActiveRecordQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
    import io.geekidea.springbootplus.framework.core.pagination.Paging;
    import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
    import com.baomidou.mybatisplus.core.metadata.IPage;
    import com.baomidou.mybatisplus.core.metadata.OrderItem;
    import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
    import org.springframework.transaction.annotation.Transactional;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * app用户活跃记录表 服务实现类
 *
 * @author giao
 * @since 2020-10-21
 */
@Slf4j
@Service
public class UserActiveRecordServiceImpl extends BaseServiceImpl<UserActiveRecordMapper, UserActiveRecord> implements UserActiveRecordService {

@Autowired
private UserActiveRecordMapper userActiveRecordMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveUserActiveRecord(UserActiveRecord userActiveRecord)throws Exception{
        return super.save(userActiveRecord);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateUserActiveRecord(UserActiveRecord userActiveRecord)throws Exception{
        return super.updateById(userActiveRecord);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteUserActiveRecord(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public UserActiveRecordQueryVo getUserActiveRecordById(Long id)throws Exception{
            return userActiveRecordMapper.getUserActiveRecordById(id);
            }

@Override
public Paging<UserActiveRecordQueryVo> getUserActiveRecordPageList(UserActiveRecordPageParam userActiveRecordPageParam)throws Exception{
        Page<UserActiveRecordQueryVo> page=new PageInfo<>(userActiveRecordPageParam,OrderItem.desc(getLambdaColumn(UserActiveRecord::getCreateTime)));
            IPage<UserActiveRecordQueryVo> iPage= userActiveRecordMapper.getUserActiveRecordPageList(page, userActiveRecordPageParam);
        return new Paging<UserActiveRecordQueryVo>(iPage);
        }

        }
