package com.jumeirah.common.mq;


import com.jumeirah.common.entity.Stroke;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2019-07-19
 */

@Component
public class Queue {

    @Autowired
    private AmqpTemplate rabbitTemplate;

    @Value("${spring.rabbitmq.user-queue-name}")
    private String userQueueName;

    @Value("${spring.rabbitmq.order-queue-name}")
    private String orderQueueName;


    /**
     * 推送订单状态到客服系统
     *
     * @param orderInteractionModel
     */
    public void pushOrder(Stroke stroke) {
        rabbitTemplate.convertAndSend(orderQueueName, stroke);
    }

    /**
     * 禁用用户
     *
     * @param userId
     */
    public void disableUserQueue(String userId) {
        rabbitTemplate.convertAndSend(userQueueName, userId);
    }


}