package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.param.McStrokePageParam;
import com.jumeirah.common.param.StrokePageParam;
import com.jumeirah.common.vo.McStrokeQueryVo;
import com.jumeirah.common.vo.StrokeDetailVo;
import com.jumeirah.common.vo.StrokeQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * 行程表 Mapper 接口
 *
 * @author wei
 * @since 2020-09-29
 */
@Repository
public interface StrokeMapper extends BaseMapper<Stroke> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    StrokeDetailVo getStrokeById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param strokePageParam
     * @return
     */
    IPage<StrokeQueryVo> getStrokePageList(@Param("page") Page page, @Param("param") StrokePageParam strokePageParam, @Param("userId") Long userId);

    /**
     * 查询已完成行程
     * @param page
     * @param strokePageParam
     * @param userId
     * @return
     */
    IPage<StrokeQueryVo> getStrokePageListWithFinish(@Param("page") Page page, @Param("param") StrokePageParam strokePageParam, @Param("userId") Long userId);

    /**
     * 商家端 获取行程分页对象
     *
     * @param page
     * @param mcStrokePageParam
     * @return
     */
    IPage<McStrokeQueryVo> getMcStrokePageList(@Param("page") Page page, @Param("mcStrokePageParam") McStrokePageParam mcStrokePageParam);
}
