package com.jumeirah.api.system.controller;

import com.jumeirah.common.entity.Merchant;
import com.jumeirah.common.param.MerchantPageParam;
import com.jumeirah.common.service.MerchantService;
import com.jumeirah.common.vo.MerchantQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 航空公司商家表 控制器
 *
 * @author giao
 * @since 2020-10-13
 */
@Slf4j
@RestController
@RequestMapping("/sys/merchant")
@Api(value = "航空公司商家表API", tags = {"航空公司商家表"})
public class MerchantController extends BaseController {

    @Autowired
    private MerchantService merchantService;

    /**
     * 添加航空公司商家表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加航空公司商家表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加航空公司商家表")
    public ApiResult<Boolean> addMerchant(@Validated(Add.class) @RequestBody Merchant merchant) throws Exception {
        boolean flag = merchantService.saveMerchant(merchant);
        return ApiResult.result(flag);
    }

    /**
     * 修改航空公司商家表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改航空公司商家表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改航空公司商家表")
    public ApiResult<Boolean> updateMerchant(@Validated(Update.class) @RequestBody Merchant merchant) throws Exception {
        boolean flag = merchantService.updateMerchant(merchant);
        return ApiResult.result(flag);
    }

    /**
     * 删除航空公司商家表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除航空公司商家表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除航空公司商家表")
    public ApiResult<Boolean> deleteMerchant(@PathVariable("id") Long id) throws Exception {
        boolean flag = merchantService.deleteMerchant(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取航空公司商家表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "航空公司商家表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "航空公司商家表详情")
    public ApiResult<MerchantQueryVo> getMerchant(@PathVariable("id") Long id) throws Exception {
        MerchantQueryVo merchantQueryVo = merchantService.getMerchantById(id);
        return ApiResult.ok(merchantQueryVo);
    }

    /**
     * 航空公司商家表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "航空公司商家表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "航空公司商家表分页列表")
    public ApiResult<Paging<MerchantQueryVo>> getMerchantPageList(@Validated @RequestBody MerchantPageParam merchantPageParam) throws Exception {
        Paging<MerchantQueryVo> paging = merchantService.getMerchantPageList(merchantPageParam);
        return ApiResult.ok(paging);
    }

}

