package com.jumeirah.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <pre>
 * 行程表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "StrokeQueryVo对象")
public class StrokeQueryVo implements Serializable {
        private static final long serialVersionUID = 1L;

        @ApiModelProperty("主键ID")
        private Long id;

        @ApiModelProperty("出发城市名称")
        private String cityOutsetName;

        @ApiModelProperty("到达城市名称")
        private String cityArriveName;

        @ApiModelProperty("出发时间")
        private Long outsetTime;

        @ApiModelProperty("返程时间")
        private Long returnTime;

        @ApiModelProperty("行程类型，0-单程，1-往返行程，2-货运，3-医疗")
        private Integer type;

        @ApiModelProperty("状态，0-审核中，1-进行中，2-已完成，99-取消")
        private Integer status;

        @ApiModelProperty("备注")
        private String remarks;

        @ApiModelProperty("价格，单位：分")
        private Long money;

        @ApiModelProperty("用户ID")
        private Long userId;
}