package com.jumeirah.api.app.controller;

import com.jumeirah.api.app.entity.vo.StrokeAddBackAndForthVo;
import com.jumeirah.api.app.entity.vo.StrokeAddFreightVo;
import com.jumeirah.api.app.entity.vo.StrokeAddMedicalTreatmentVo;
import com.jumeirah.api.app.entity.vo.StrokeAddOneWayVo;
import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.param.StrokePageParam;
import com.jumeirah.common.service.StrokeService;
import com.jumeirah.common.vo.StrokeDetailVo;
import com.jumeirah.common.vo.StrokeQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 行程表 控制器
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@RestController
@RequestMapping("/stroke")
@Api(value = "行程表API", tags = {"行程表"})
public class StrokeController extends BaseController {

    @Autowired
    private StrokeService strokeService;

    /**
     * 添加单程行程表
     */
    @PostMapping("/add/oneWay")
    @OperationLog(name = "添加单程行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加单程行程表", response = ApiResult.class)
    public ApiResult<Boolean> addOneWayStroke(@Validated @RequestBody StrokeAddOneWayVo strokeAddOneWayVo) throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        Stroke stroke = new Stroke();
        BeanUtils.copyProperties(strokeAddOneWayVo, stroke);
        stroke.setType(0)
                .setCreateTime(System.currentTimeMillis());
        boolean flag = strokeService.saveStroke(stroke);
        return ApiResult.result(flag);
    }

    /**
     * 添加往返行程表
     */
    @PostMapping("/add/backAndForth")
    @OperationLog(name = "添加往返行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加往返行程表", response = ApiResult.class)
    public ApiResult<Boolean> addBackAndForthStroke(@Validated @RequestBody StrokeAddBackAndForthVo strokeAddBackAndForthVo) throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        Stroke stroke = new Stroke();
        BeanUtils.copyProperties(strokeAddBackAndForthVo, stroke);
        stroke.setType(1)
                .setCreateTime(System.currentTimeMillis());
        boolean flag = strokeService.saveStroke(stroke);
        return ApiResult.result(flag);
    }

    /**
     * 添加货运行程表
     */
    @PostMapping("/add/freight")
    @OperationLog(name = "添加货运行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加货运行程表", response = ApiResult.class)
    public ApiResult<Boolean> addFreightStroke(@Validated @RequestBody StrokeAddFreightVo strokeAddFreightVo) throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        Stroke stroke = new Stroke();
        BeanUtils.copyProperties(strokeAddFreightVo, stroke);
        stroke.setType(2)
                .setCreateTime(System.currentTimeMillis());
        boolean flag = strokeService.saveStroke(stroke);
        return ApiResult.result(flag);
    }

    /**
     * 添加医疗行程表
     */
    @PostMapping("/add/medicalTreatment")
    @OperationLog(name = "添加医疗行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加医疗行程表", response = ApiResult.class)
    public ApiResult<Boolean> addMedicalTreatmentStroke(
            @Validated @RequestBody StrokeAddMedicalTreatmentVo strokeAddMedicalTreatmentVo) throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        Stroke stroke = new Stroke();
        BeanUtils.copyProperties(strokeAddMedicalTreatmentVo, stroke);
        stroke.setType(3)
                .setCreateTime(System.currentTimeMillis());
        boolean flag = strokeService.saveStroke(stroke);
        return ApiResult.result(flag);
    }


//    /**
//     * 修改行程表
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改行程表", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改行程表", response = ApiResult.class)
//    public ApiResult<Boolean> updateStroke(@Validated(Update.class) @RequestBody Stroke stroke) throws Exception {
//        boolean flag = strokeService.updateStroke(stroke);
//        return ApiResult.result(flag);
//    }

    /**
     * 删除行程表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除行程表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除行程表", response = ApiResult.class)
    public ApiResult<Boolean> deleteStroke(@PathVariable("id") Long id) throws Exception {
        boolean flag = strokeService.deleteStroke(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取行程表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "行程表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "行程表详情", response = StrokeDetailVo.class)
    public ApiResult<StrokeDetailVo> getStroke(@PathVariable("id") Long id) throws Exception {
        StrokeDetailVo strokeQueryVo = strokeService.getStrokeById(id);
        return ApiResult.ok(strokeQueryVo);
    }

//    /**
//     * 行程表分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "行程表分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "行程表分页列表", response = StrokeQueryVo.class)
//    public ApiResult<Paging<StrokeQueryVo>> getStrokePageList(@Validated @RequestBody StrokePageParam strokePageParam) throws Exception {
//        Paging<StrokeQueryVo> paging = strokeService.getStrokePageList(strokePageParam);
//        return ApiResult.ok(paging);
//    }

    /**
     * 行程表分页列表
     */
    @PostMapping("/getMyStrokePageList")
    @OperationLog(name = "行程分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "行程分页列表", response = StrokeQueryVo.class)
    public ApiResult<Paging<StrokeQueryVo>> getMyStrokePageList(@Validated @RequestBody StrokePageParam strokePageParam) throws Exception {
        Paging<StrokeQueryVo> paging = strokeService.getStrokePageList(strokePageParam);
        return ApiResult.ok(paging);
    }

}

