/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.sien.common.param.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 注册参数
 *
 * @author geekidea
 * @date 2019-05-15
 **/
@Data
@ApiModel("AppSmsRegisterParam")
@Validated
public class AppSmsRegisterParam implements Serializable {

    @NotBlank(message = "姓名")
    @ApiModelProperty(value = "姓名", example = "何", required = true)
    private String userName;

    @NotBlank(message = "请输入手机区号")
    @ApiModelProperty(value = "手机区号", example = "86", required = true)
    private String phoneArea;

    @NotBlank(message = "请输入手机号")
    @ApiModelProperty(value = "手机号", example = "17621701100", required = true)
    private String phone;

    @ApiModelProperty(value = "短信验证码", example = "666666", required = true)
    @NotBlank(message = "请输入手机号")
    private String smsCode;

    @ApiModelProperty(value = "check接口中返回的openId", example = "adfadlsfadsf")
    @NotBlank(message = "请输入openId")
    private String openId;

}
