package tillo.app_ws.service.impl;

import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tillo.app_ws.model.ResponseModel;
import tillo.app_ws.model.ResultStatus;
import tillo.app_ws.model.request.ReceiveModel;
import tillo.app_ws.service.AppUserChannelsService;
import tillo.app_ws.service.WriteDataService;

import java.util.HashMap;

/**
 * @Description 下发数据
 * @Author hewei hwei1233@163.com
 * @Date 2019-12-05
 */
@Component
public class WriteDataServiceImpl implements WriteDataService {

    @Autowired
    private AppUserChannelsService appUserChannelsService;

    @Override
    public void successAndData(ReceiveModel requestModel, Object data, Long userId, String language) {
        this.dataAndStatus(requestModel, ResultStatus.SUCCESS, data, userId, language);
    }

    @Override
    public void nullDataSuccess(ReceiveModel requestModel, ResultStatus resultStatus, Long userId, String language) {
        this.dataAndStatus(requestModel, resultStatus, new HashMap<>(1), userId, language);
    }

    @Override
    public void paramErrorAndNullData(ReceiveModel requestModel, Long userId, String language) {
//        this.nullDataSuccess(requestModel, ResultStatus.PARAM_ERROR, userId, language);
    }


    @Override
    public void dataAndStatus(ReceiveModel requestModel, ResultStatus resultStatus, Object data, Long userId, String language) {
//        ResultModel<String> resultModel = new ResultModel<>(resultStatus, language);
//
//        ResponseModel responseModel = new ResponseModel();
//        responseModel.setMsg(resultModel.getMessage());
//        responseModel.setPath(requestModel.getPath());
//        responseModel.setReqId(requestModel.getReqId());
//        responseModel.setData(data);
//        responseModel.setCode(resultModel.getStatus());
//        this.write(responseModel, userId);
    }

    @Override
    public void write(ResponseModel responseModel, Long userId) {
        String json = JSON.toJSONString(responseModel);
        appUserChannelsService.writeData(json, userId);
    }

}
