package io.geekidea.springbootplus.test;

import com.sien.common.factory.PushFactory;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(SpringRunner.class)
@SpringBootTest
public class SpiringPlusTest {

    @Autowired
    private PushFactory pushFactory;




    /**
     * app推送：1.您有一条新消息（客服回复推送）
     * 2.您的订单已报价（商家端报价完后推送）
     * 3.您的订单已完成（商家端完成行程完后推送
     *
     * @throws Exception
     */
    @Test
    public void push() throws Exception {

        pushFactory.getService(1).unicast("Ar4opHQcGn-UA1-fZ7O6PAeNSJs9rCEEI5XRvS_0rQke", "2", "您的订单已报价");

        pushFactory.getService(1).unicast("Ar4opHQcGn-UA1-fZ7O6PAeNSJs9rCEEI5XRvS_0rQke", "3", "您的订单已完成");

    }







}
