package com.jumeirah.common.service;

import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.param.AppUserPageParam;
import com.jumeirah.common.param.LoginParam;
import com.jumeirah.common.param.RegisterParam;
import com.jumeirah.common.vo.AppUserQueryVo;
import com.jumeirah.common.vo.LoginSysUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * APP用户 服务类
 *
 * @author wei
 * @since 2020-09-23
 */
public interface AppUserService extends BaseService<AppUser> {

        ApiResult<LoginSysUserTokenVo> register(RegisterParam registerParam, String language);
        ApiResult<LoginSysUserTokenVo> login(LoginParam loginParam, String language);



        ApiResult<LoginSysUserTokenVo> phoneLogin(RegisterParam registerParam, String language);
        /**
         * 保存
         *
         * @param appUser
         * @return
         * @throws Exception
         */
        boolean saveAppUser(AppUser appUser)throws Exception;

        /**
         * 修改
         *
         * @param appUser
         * @return
         * @throws Exception
         */
        boolean updateAppUser(AppUser appUser)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteAppUser(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        AppUserQueryVo getAppUserById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param appUserPageParam
         * @return
         * @throws Exception
         */
        Paging<AppUserQueryVo> getAppUserPageList(AppUserPageParam appUserPageParam) throws Exception;

        }
