package com.ym.im.controller;

import com.ym.im.entity.IdModel;
import com.ym.im.entity.MsgBody;
import com.ym.im.service.StaffService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @author: JJww
 * 客服
 * @Date:2019-05-22
 */
@RestController
@RequestMapping("/staff")
@Api(description = "客服相关")
public class StaffController {

    @Autowired
    private StaffService staffService;

    @GetMapping(value = "/getStaffList")
    @ApiOperation(value = "获取所有客服信息")
    public MsgBody getStaffList() {
        return staffService.getStaffList();
    }

    @PostMapping(value = "/forward")
    @ApiOperation(value = "转发")
    public MsgBody forward(@Valid @RequestBody IdModel idModel) {
        return staffService.forward(idModel);
    }

}
