package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.MerchantUserPermission;
import com.jumeirah.common.mapper.MerchantUserPermissionMapper;
import com.jumeirah.common.param.MerchantUserPermissionPageParam;
import com.jumeirah.common.param.MerchantUserPermissionQueryVo;
import com.jumeirah.common.service.MerchantUserPermissionService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Set;

/**
 * 商家用户权限关系 服务实现类
 *
 * @author giao
 * @since 2020-10-19
 */
@Slf4j
@Service
public class MerchantUserPermissionServiceImpl extends BaseServiceImpl<MerchantUserPermissionMapper, MerchantUserPermission> implements MerchantUserPermissionService {

    @Autowired
    private MerchantUserPermissionMapper merchantUserPermissionMapper;

    @Override
    public Set<String> getPermissionCodesByUserId(Long userId) throws Exception {
        return merchantUserPermissionMapper.getPermissionCodesByUserId(userId);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveMerchantUserPermission(MerchantUserPermission merchantUserPermission) throws Exception {
        return super.save(merchantUserPermission);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateMerchantUserPermission(MerchantUserPermission merchantUserPermission) throws Exception {
        return super.updateById(merchantUserPermission);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteMerchantUserPermission(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public MerchantUserPermissionQueryVo getMerchantUserPermissionById(Long id) throws Exception {
        return merchantUserPermissionMapper.getMerchantUserPermissionById(id);
    }

    @Override
    public Paging<MerchantUserPermissionQueryVo> getMerchantUserPermissionPageList(MerchantUserPermissionPageParam merchantUserPermissionPageParam) throws Exception {
        Page<MerchantUserPermissionQueryVo> page = new PageInfo<>(merchantUserPermissionPageParam, OrderItem.desc(getLambdaColumn(MerchantUserPermission::getCreateTime)));
        IPage<MerchantUserPermissionQueryVo> iPage = merchantUserPermissionMapper.getMerchantUserPermissionPageList(page, merchantUserPermissionPageParam);
        return new Paging<MerchantUserPermissionQueryVo>(iPage);
    }

}
