package com.jumeirah.common.service;

import com.jumeirah.common.entity.Merchant;
import com.jumeirah.common.param.MerchantPageParam;
import com.jumeirah.common.vo.MerchantQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 航空公司商家表 服务类
 *
 * @author giao
 * @since 2020-10-13
 */
public interface MerchantService extends BaseService<Merchant> {

    /**
     * 保存
     *
     * @param merchant
     * @return
     * @throws Exception
     */
    boolean saveMerchant(Merchant merchant) throws Exception;

    /**
     * 修改
     *
     * @param merchant
     * @return
     * @throws Exception
     */
    boolean updateMerchant(Merchant merchant) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteMerchant(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    MerchantQueryVo getMerchantById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param merchantPageParam
     * @return
     * @throws Exception
     */
    Paging<MerchantQueryVo> getMerchantPageList(MerchantPageParam merchantPageParam) throws Exception;

}
