package com.sien.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.VipRecord;
import com.sien.common.param.VipRecordPageParam;
import com.sien.common.vo.VipRecordQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;

/**
 * Vip开通记录 Mapper 接口
 *
 * @author hewei
 * @since 2021-02-25
 */
@Repository
public interface VipRecordMapper extends BaseMapper<VipRecord> {

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    VipRecordQueryVo getVipRecordById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param vipRecordPageParam
     * @return
     */
    IPage<VipRecordQueryVo> getVipRecordPageList(@Param("page") Page page, @Param("param") VipRecordPageParam vipRecordPageParam);

}
