package com.jumeirah.common.vo;

    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import lombok.Data;
    import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 商家权限 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-28
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "MerchantPermissionQueryVo对象")
public class MerchantPermissionQueryVo implements Serializable{
private static final long serialVersionUID=1L;

        @ApiModelProperty("主键")
private Long id;

        @ApiModelProperty("权限名称")
private String name;

        @ApiModelProperty("父id")
private Long parentId;

        @ApiModelProperty("路径")
private String url;

        @ApiModelProperty("唯一编码")
private String code;

        @ApiModelProperty("图标")
private String icon;

        @ApiModelProperty("类型，1：菜单，2：按钮")
private Integer type;

        @ApiModelProperty("层级，1：第一级，2：第二级，N：第N级")
private Integer level;

        @ApiModelProperty("状态，0：禁用，1：启用")
private Integer state;

        @ApiModelProperty("排序")
private Integer sort;

        @ApiModelProperty("备注")
private String remark;

        @ApiModelProperty("版本")
private Integer version;

        @ApiModelProperty("创建时间")
private Date createTime;

        @ApiModelProperty("修改时间")
private Date updateTime;
}