package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.AppUser;
import com.jumeirah.common.param.AppUserPageParam;
import com.jumeirah.common.vo.AppUserQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * APP用户 Mapper 接口
 *
 * @author wei
 * @since 2020-09-23
 */
@Repository
public interface AppUserMapper extends BaseMapper<AppUser> {

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             */
        AppUserQueryVo getAppUserById(Serializable id);

            /**
             * 获取分页对象
             *
             * @param page
             * @param appUserPageParam
             * @return
             */
            IPage<AppUserQueryVo> getAppUserPageList(@Param("page") Page page,@Param("param") AppUserPageParam appUserPageParam);

        }
