package com.jumeirah.common.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Stroke报价对象")
public class StrokeQuotedPriceParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空")
    @ApiModelProperty("主键ID")
    private Long id;

    @NotNull(message = "飞机型号ID不能为空")
    @ApiModelProperty("飞机型号ID")
    private Long plainTypeId;

    @NotNull(message = "价格不能为空")
    @ApiModelProperty("价格")
    private BigDecimal money;

    @ApiModelProperty("备注")
    private String remarks;



}
