package com.sien.common.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 状态，0-审核中，1-进行中，2-已完成，99-取消
 */
@Getter
@AllArgsConstructor
public enum StrokeStatusEnum implements BaseEnum {

    UNDER_REVIEW(0, "审核中"),
    PROCESSING(1, "进行中"),
    COMPLETED(2, "已完成"),
    CANCEL(99, "取消");

    /**
     * 编号
     */
    private final Integer code;
    /**
     * 名称
     */
    private final String desc;


}
