package com.ym.im.entity.enums;

/**
 * 自定义请求状态码
 *
 * @author JJww
 */
public enum ResultStatus {
    /**
     * 成功
     */
    SUCCESS(200, "Success", "成功"),
    PRIVILEGE_IS_ERROR(401, "Unauthorized", "未授权限，请联系管理员"),

    THERE_IS_NO_ONLINE_CUSTOMER_SERVICE(10000, "There is no online customer service", "当前没有客服在线"),
    MOBILE_NO_REGISTER(20000, "The mobile phone number is registered", "手机号未注册"),
    MOBILE_REGISTER(20001, "Mobile phone number has been registered", "手机号已注册"),
    USER_INFO_NO_EXIST(20003, "User information does not exist", "用户信息不存在"),
    REPEAT_COMMIT(20007, "your commit is repeat", "重复提交"),
    FORWARD_FAILURE(40004, "Failed to forward, customer service or user offline", "转发失败,客服或用户已下线"),
    CHECK_FAILURE(40005, "This user has binding other staff", "此用户已经绑定其他客服"),
    PARAM_ERROR(9999, "Parameters error", "参数有误"),
    SYS_BUSY(-9998, "The system is busy, please try again later!", "系统繁忙，请稍候再试！"),
    SYS_ERROR(-9999, "System error", "系统错误！"),
    REQUEST_ERROR(-9997, "Request error", "请求有误！"),
    FORBIDDEN_ERROR(-9996, "forbidden error", "用户已被封禁");


    /**
     * 返回码
     */
    private int code;

    /**
     * 默认返回英文结果描述 en
     */
    private String message;

    /**
     * 返回中文结果描述 zh_simple
     */
    private String zhMessage;

    ResultStatus(int code, String message, String zhMessage) {
        this.code = code;
        this.message = message;
        this.zhMessage = zhMessage;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getZhMessage() {
        return zhMessage;
    }

    public void setZhMessage(String zhMessage) {
        this.zhMessage = zhMessage;
    }

}
