package com.ym.im.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ym.im.entity.ChatRecord;
import com.ym.im.entity.MsgBody;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.nio.NioSocketChannel;

import javax.validation.Valid;

/**
 * @author: JJww
 * @Date:2019-05-21
 */
public interface ChatService {

    /**
     * 连接初始化
     *
     * @param ctx
     * @return
     */
    void init(ChannelHandlerContext ctx);


    /**
     * 发送
     *
     * @param msgBody
     * @throws JsonProcessingException
     */
    void send(NioSocketChannel channel, MsgBody<ChatRecord> msgBody) throws JsonProcessingException;

    /**
     * 离线
     *
     * @param ctx
     * @throws JsonProcessingException
     */
    void offline(ChannelHandlerContext ctx);

    /**
     * 回执
     *
     * @param msgBody
     * @throws JsonProcessingException
     */
    void ack(@Valid MsgBody<ChatRecord> msgBody) throws JsonProcessingException;

    /**
     * 保存消息
     *
     * @param id
     * @param msgBody
     */
    void save(Long id, @Valid MsgBody<ChatRecord> msgBody);

    /**
     * 分配
     *
     * @param id
     * @param msgBody
     * @return
     */
    NioSocketChannel distribution(Long id,@Valid MsgBody<ChatRecord> msgBody);


}
