package com.ym.im.factory;

import com.ym.im.entity.NettyConstant;
import com.ym.im.exception.IMessageException;
import com.ym.im.service.ChatService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author: JJww
 * @Date:2019-05-23
 */
@Component
public class SingleChatFactory {

    @Autowired
    private ChatService userSingleChatServiceImpl;

    @Autowired
    private ChatService staffSingleChatServiceImpl;

    /**
     * 创建对应实现类
     *
     * @param type
     * @return
     */
    public ChatService getService(Integer type) {

        if (type == null) {
            return null;
        }

        switch (type) {

            case NettyConstant.CONNECT_TYPE_USER:
                return userSingleChatServiceImpl;

            case NettyConstant.CONNECT_TYPE_STAFF:
                return staffSingleChatServiceImpl;

            default:
                return null;
        }
    }

}
