package com.jumeirah.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 公务机出售/托管表
 *
 * @author giao
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "BusinessPlain对象")
public class BusinessPlain extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键ID不能为空")
    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "商家ID不能为空")
    @ApiModelProperty("商家ID")
    private Long mcId;

    @NotNull(message = "业务类型，0-出售，1-托管不能为空")
    @ApiModelProperty("业务类型，0-出售，1-托管")
    private Integer businessType;

    @ApiModelProperty("图片url")
    private String imgUrl;

    @ApiModelProperty("机型介绍")
    private String introduction;

    @ApiModelProperty("销售员姓名")
    private String name;

    @ApiModelProperty("销售联系电话")
    private String phone;

    @ApiModelProperty("微信号")
    private String wechat;

    @NotNull(message = "状态，0-正常，1-禁用，99-删除不能为空")
    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间（时间戳）")
    private Date createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Date updateTime;

}
