package com.jumeirah.common.controller;

import com.jumeirah.common.entity.StrokeDiscount;
import com.jumeirah.common.param.StrokeDiscountPageParam;
import com.jumeirah.common.service.StrokeDiscountService;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 优惠行程表 控制器
 *
 * @author xxx
 * @since 2020-10-14
 */
/*@Slf4j
@RestController
@RequestMapping("/strokeDiscount")
@Api(value = "优惠行程表API", tags = {"优惠行程表"})*/
public class StrokeDiscountController extends BaseController {

    @Autowired
    private StrokeDiscountService strokeDiscountService;

    /**
     * 添加优惠行程表
     */
    @PostMapping("/add")
    @OperationLog(name = "添加优惠行程表", type = OperationLogType.ADD)
    @ApiOperation(value = "添加优惠行程表")
    public ApiResult<Boolean> addStrokeDiscount(@Validated(Add.class) @RequestBody StrokeDiscount strokeDiscount) throws Exception {
        boolean flag = strokeDiscountService.saveStrokeDiscount(strokeDiscount);
        return ApiResult.result(flag);
    }

    /**
     * 修改优惠行程表
     */
    @PostMapping("/update")
    @OperationLog(name = "修改优惠行程表", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改优惠行程表")
    public ApiResult<Boolean> updateStrokeDiscount(@Validated(Update.class) @RequestBody StrokeDiscount strokeDiscount) throws Exception {
        boolean flag = strokeDiscountService.updateStrokeDiscount(strokeDiscount);
        return ApiResult.result(flag);
    }

    /**
     * 删除优惠行程表
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除优惠行程表", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除优惠行程表")
    public ApiResult<Boolean> deleteStrokeDiscount(@PathVariable("id") Long id) throws Exception {
        boolean flag = strokeDiscountService.deleteStrokeDiscount(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取优惠行程表详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "优惠行程表详情", type = OperationLogType.INFO)
    @ApiOperation(value = "优惠行程表详情")
    public ApiResult<StrokeDiscountQueryVo> getStrokeDiscount(@PathVariable("id") Long id) throws Exception {
        StrokeDiscountQueryVo strokeDiscountQueryVo = strokeDiscountService.getStrokeDiscountById(id);
        return ApiResult.ok(strokeDiscountQueryVo);
    }

    /**
     * 优惠行程表分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "优惠行程表分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "优惠行程表分页列表")
    public ApiResult<Paging<StrokeDiscountQueryVo>> getStrokeDiscountPageList(@Validated @RequestBody StrokeDiscountPageParam strokeDiscountPageParam) throws Exception {
        Paging<StrokeDiscountQueryVo> paging = strokeDiscountService.getStrokeDiscountPageList(strokeDiscountPageParam);
        return ApiResult.ok(paging);
    }

}

