/*
 * Copyright 2019-2029 geekidea(https://github.com/geekidea)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jumeirah.common.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 注册参数
 *
 * @author geekidea
 * @date 2019-05-15
 **/
@Data
@ApiModel("注册参数")
public class MerchantRegisterParam implements Serializable {
    private static final long serialVersionUID = 2854217576695117357L;

    @NotBlank(message = "请输入密码")
    @ApiModelProperty(value = "密码", example = "123456")
    private String password;

    @NotBlank(message = "参数不能为空")
    @ApiModelProperty("验证码")
    private String smsCode;

    @ApiModelProperty("商家名称")
    @NotBlank(message = "参数不能为空")
    private String name;

    @ApiModelProperty("联系人手机号码")
    @NotBlank(message = "请输入手机号")
    private String phone;

    @ApiModelProperty("联系人手机区号")
    private String phoneArea;

    @ApiModelProperty("公司所在地址")
    private String location;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("营业执照图片url, 为多张可以传入数组")
    private String imageBusinessLicenseUrl;

}
