package com.jumeirah.api.app.controller;


import com.jumeirah.api.app.entity.bo.PlainTypeBo;
import com.jumeirah.common.entity.PlainType;
import com.jumeirah.common.service.PlainTypeService;
import com.jumeirah.common.vo.PlainTypeQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 飞机型号表 控制器
 *
 * @author wei
 * @since 2020-10-09
 */
@Slf4j
@RestController
@RequestMapping("/app/plainType")
@Module("${cfg.module}")
@Api(value = "飞机型号表API", tags = {"飞机型号表"})
public class PlainTypeController extends BaseController {

    @Autowired
    private PlainTypeService plainTypeService;

    /**
     *  app端飞机型号表分页列表
     */
    @GetMapping("/getAllMap")
    @OperationLog(name = "分组获取飞机型号列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "分组获取飞机型号列表", response = PlainTypeQueryVo.class)
    public ApiResult<List<PlainTypeBo>> getAllMap() throws Exception {
       List<PlainType> plainTypeList = plainTypeService.getAppPlainTypePageList();
        Map<Integer, List<PlainType>> resultMap;
        List<PlainTypeBo> plainTypeBoList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(plainTypeList)) {
            resultMap = plainTypeList.stream().collect(Collectors.groupingBy(PlainType::getSeriesType));
            PlainTypeBo plainTypeBo;
            for (List<PlainType> listTemp: resultMap.values()) {
                plainTypeBo = new PlainTypeBo();
                plainTypeBo.setType(listTemp.get(0).getSeriesType())
                        .setPlainTypeList(listTemp);
                plainTypeBoList.add(plainTypeBo);
            }
        }
        return ApiResult.ok(plainTypeBoList);
    }

}

