package com.sien.common.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.sien.common.entity.base.ImgJson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;

/**
 * <pre>
 * 公务机出售/托管表 查询结果对象
 * </pre>
 *
 * @author giao
 * @date 2020-10-14
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "BusinessPlainQueryVo对象")
@TableName(autoResultMap = true)
public class BusinessPlainQueryVo  implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("商家ID")
    private Long mcId;

    @ApiModelProperty("业务类型，0-出售，1-托管")
    private Integer businessType;

    @ApiModelProperty("机型介绍")
    private String introduction;

    @ApiModelProperty("销售员姓名")
    private String name;

    @ApiModelProperty("销售联系电话")
    private String phone;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("状态，0-正常，1-禁用，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间（时间戳）")
    private Timestamp createTime;

    @ApiModelProperty("更新时间（时间戳）")
    private Timestamp updateTime;

    @TableField(typeHandler = FastjsonTypeHandler.class)
    @ApiModelProperty("图片相关数据json (包括：路径，宽和高)")
    private List<ImgJson> imgList;
}
