package com.sien.common.service;

import com.sien.common.entity.DonationRecord;
import com.sien.common.param.DonationRecordPageParam;
import com.sien.common.vo.DonationRankAndTotal;
import com.sien.common.vo.DonationRecordQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 捐款记录 服务类
 *
 * @author hewei
 * @since 2021-02-25
 */
public interface DonationRecordService extends BaseService<DonationRecord> {


        /**
         * 查询捐款排名和总捐款
         *
         * @param userId
         * @return
         */
        DonationRankAndTotal getDonationRankAndTotal(Long userId);

        /**
         * 保存
         *
         * @param donationRecord
         * @return
         * @throws Exception
         */
        boolean saveDonationRecord(DonationRecord donationRecord) throws Exception;

        /**
         * 修改
         *
         * @param donationRecord
         * @return
         * @throws Exception
         */
        boolean updateDonationRecord(DonationRecord donationRecord)throws Exception;

        /**
         * 删除
         *
         * @param id
         * @return
         * @throws Exception
         */
        boolean deleteDonationRecord(Long id)throws Exception;

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             * @throws Exception
             */
        DonationRecordQueryVo getDonationRecordById(Long id)throws Exception;

        /**
         * 获取分页对象
         *
         * @param donationRecordPageParam
         * @return
         * @throws Exception
         */
        Paging<DonationRecordQueryVo> getDonationRecordPageList(DonationRecordPageParam donationRecordPageParam) throws Exception;

        }
