package com.sien.common.param.app;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <pre>
 * 行程付款信息填写
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "行程付款信息填写")
public class StrokePaymentInfoParam implements Serializable {
        private static final long serialVersionUID = 1L;

        @NotNull(message = "id不能为空")
        @ApiModelProperty("主键ID")
        private Long id;

        @NotNull(message = "用户充值金额不能为空")
        @ApiModelProperty("用户充值金额")
        private BigDecimal userRechargeMoney;

        @NotBlank(message = "用户充值账户名不能为空")
        @ApiModelProperty("用户充值账户名")
        private String userRechargeName;

        @NotBlank(message = "用户充值卡号不能为空")
        @ApiModelProperty("用户充值卡号")
        private String userRechargeBankNumber;

        @NotBlank(message = "用户充值截图证据,  传入数组不能为空")
        @ApiModelProperty("用户充值截图证据,  传入数组")
        private String userRechargeCredentialsUrl;

}
