package com.sien.common.controller;

import com.sien.common.service.AppUserService;
import com.sien.common.vo.AppUserQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * APP用户 控制器
 *
 * @author wei
 * @since 2020-09-23
 */
@Slf4j
@RestController
@Module("api-app")
@Api(value = "微信登陆相关", tags = {"微信登陆相关"})
@RequestMapping("/wechatUser")
public class WechatUserController extends BaseController {

    @Autowired
    private AppUserService appUserService;

    /**
     * 根据微信重定向code查询用户是否绑定
     */
    @GetMapping("/check/")
    @OperationLog(name = "根据微信重定向code查询用户是否绑定", type = OperationLogType.INFO)
    @ApiOperation(value = "根据微信重定向code查询用户是否绑定", response = AppUserQueryVo.class)
    public ApiResult<AppUserQueryVo> getAppUser() throws Exception {
        AppUserQueryVo appUserQueryVo = appUserService.getMyInfo();
        return ApiResult.ok(appUserQueryVo);
    }


}

