package com.jumeirah.common.vo;

    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import lombok.Data;
    import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 行程表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "StrokeQueryVo对象")
public class StrokeQueryVo implements Serializable{
private static final long serialVersionUID=1L;

        @ApiModelProperty("主键ID")
private Long id;

        @ApiModelProperty("出发城市id")
private Long cityOutsetId;

        @ApiModelProperty("出发城市名称")
private String cityOutsetName;

        @ApiModelProperty("到达城市id")
private Long cityArriveId;

        @ApiModelProperty("到达城市名称")
private String cityArriveName;

        @ApiModelProperty("人数")
private Integer peopleMun;

        @ApiModelProperty("飞机型号ID")
private Long plainTypeId;

        @ApiModelProperty("出发时间")
private Date outsetTime;

        @ApiModelProperty("返程时间")
private Date returnTime;

        @ApiModelProperty("行程类型，0-单程，1-往返行程，2-货运，3-医疗")
private Integer type;

        @ApiModelProperty("状态，0-审核中，1-进行中，2-已完成，99-取消")
private Integer status;

        @ApiModelProperty("创建时间")
private Long createTime;

        @ApiModelProperty("更新时间")
private Long updateTime;

        @ApiModelProperty("货物名称")
private String goodsName;

        @ApiModelProperty("货物体积（长*宽*高） 单位：CM，例如：100*102*120")
private String goodsSize;

        @ApiModelProperty("货物重量，单位：吨")
private Double goodsWeight;

        @ApiModelProperty("病人疾病名称")
private String diseaseName;

        @ApiModelProperty("病人病情诊断书")
private String aegerUrl;

        @ApiModelProperty("配备器械（格式：1,2,3）逗号分隔")
private String instruments;

        @ApiModelProperty("医护人员，0-医生，1-护士，2-护工（格式：0,1,2）逗号分隔")
private String medicalPersons;

        @ApiModelProperty("备注")
private String remarks;

        @ApiModelProperty("价格，单位：分")
private Long money;

        @ApiModelProperty("用户ID")
private Long userId;
}