package com.jumeirah.common.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * <pre>
 * 行程表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "StrokeQueryVo对象")
public class McStrokePaymentQueryVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键ID")
    private Long id;

    @ApiModelProperty("行程类型，0-单程，1-往返行程，2-货运，3-医疗")
    private Integer type;

    @ApiModelProperty("付款时间")
    private Timestamp userRechargeTime;

    @ApiModelProperty("付款状态，0-未付款，1-付款中，2-已付款，3-退款中，99-已退款")
    private Integer paymentStatus;

    @ApiModelProperty("用户充值金额")
    private BigDecimal userRechargeMoney;

    @ApiModelProperty("手机号")
    private String phoneNumber;

    @ApiModelProperty("申请人")
    private String applicant;

    @ApiModelProperty("付款渠道，0-线下渠道，1-线上渠道")
    private Integer paymentChannel;


}
