//package com.jumeirah.api.merchant.controller;
//
//import com.jumeirah.common.entity.MerchantPermission;
//import com.jumeirah.common.param.MerchantPermissionPageParam;
//import com.jumeirah.common.service.MerchantPermissionService;
//import com.jumeirah.common.vo.MerchantPermissionQueryVo;
//import io.geekidea.springbootplus.framework.common.api.ApiResult;
//import io.geekidea.springbootplus.framework.common.controller.BaseController;
//import io.geekidea.springbootplus.framework.core.pagination.Paging;
//import io.geekidea.springbootplus.framework.core.validator.groups.Add;
//import io.geekidea.springbootplus.framework.core.validator.groups.Update;
//import io.geekidea.springbootplus.framework.log.annotation.Module;
//import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
//import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.validation.annotation.Validated;
//import org.springframework.web.bind.annotation.GetMapping;
//import org.springframework.web.bind.annotation.PathVariable;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
///**
// * 商家权限 控制器
// *
// * @author wei
// * @since 2020-09-27
// */
//@Slf4j
//@RestController
//@RequestMapping("/merchant/permission")
//@Module("${cfg.module}")
//@Api(value = "商家权限API", tags = {"商家权限"})
//public class MerchantPermissionController extends BaseController {
//
//    @Autowired
//    private MerchantPermissionService merchantPermissionService;
//
//    /**
//     * 添加商家权限
//     */
//    @PostMapping("/add")
//    @OperationLog(name = "添加商家权限", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加商家权限", response = ApiResult.class)
//    public ApiResult<Boolean> addMerchantPermission(@Validated(Add.class) @RequestBody MerchantPermission merchantPermission) throws Exception {
//        boolean flag = merchantPermissionService.saveMerchantPermission(merchantPermission);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 修改商家权限
//     */
//    @PostMapping("/update")
//    @OperationLog(name = "修改商家权限", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改商家权限", response = ApiResult.class)
//    public ApiResult<Boolean> updateMerchantPermission(@Validated(Update.class) @RequestBody MerchantPermission merchantPermission) throws Exception {
//        boolean flag = merchantPermissionService.updateMerchantPermission(merchantPermission);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 删除商家权限
//     */
//    @PostMapping("/delete/{id}")
//    @OperationLog(name = "删除商家权限", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除商家权限", response = ApiResult.class)
//    public ApiResult<Boolean> deleteMerchantPermission(@PathVariable("id") Long id) throws Exception {
//        boolean flag = merchantPermissionService.deleteMerchantPermission(id);
//        return ApiResult.result(flag);
//    }
//
//    /**
//     * 获取商家权限详情
//     */
//    @GetMapping("/info/{id}")
//    @OperationLog(name = "商家权限详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "商家权限详情", response = MerchantPermissionQueryVo.class)
//    public ApiResult<MerchantPermissionQueryVo> getMerchantPermission(@PathVariable("id") Long id) throws Exception {
//        MerchantPermissionQueryVo merchantPermissionQueryVo = merchantPermissionService.getMerchantPermissionById(id);
//        return ApiResult.ok(merchantPermissionQueryVo);
//    }
//
//    /**
//     * 商家权限分页列表
//     */
//    @PostMapping("/getPageList")
//    @OperationLog(name = "商家权限分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "商家权限分页列表", response = MerchantPermissionQueryVo.class)
//    public ApiResult<Paging<MerchantPermissionQueryVo>> getMerchantPermissionPageList(@Validated @RequestBody MerchantPermissionPageParam merchantPermissionPageParam) throws Exception {
//        Paging<MerchantPermissionQueryVo> paging = merchantPermissionService.getMerchantPermissionPageList(merchantPermissionPageParam);
//        return ApiResult.ok(paging);
//    }
//
//}
//
